(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[5],{100:function(module,exports,__webpack_require__){"use strict";eval('\n\n/* global ajaxurl */\n/* jshint -W097 */\n\nvar redirectFunctions = __webpack_require__(18);\n\n/**\n * Use notification counter so we can count how many times the function wpseoShowNotification is called.\n *\n * @type {number}\n */\nvar wpseoNotificationCounter = 0;\n\n/**\n * Show notification to user when there\'s a redirect created. When the response is empty, up the notification counter\n * with 1, wait 100 ms and call function again.\n * Stop when the notification counter is bigger than 20.\n *\n * @returns {void}\n */\nfunction wpseoShowNotification() {\n\tjQuery.post(ajaxurl, { action: "yoast_get_notifications" }, function (response) {\n\t\tif (response !== "") {\n\t\t\tvar insertAfterElement = jQuery(".wrap").children().eq(0);\n\t\t\tjQuery(response).insertAfter(insertAfterElement);\n\t\t\twpseoNotificationCounter = 0;\n\t\t}\n\n\t\tif (wpseoNotificationCounter < 20 && response === "") {\n\t\t\twpseoNotificationCounter++;\n\t\t\tsetTimeout(wpseoShowNotification, 500);\n\t\t}\n\t});\n}\n\nwindow.wpseoShowNotification = wpseoShowNotification;\n\n/**\n * Gets the current page based on the current URL.\n *\n * @returns {string} The current page.\n */\nfunction wpseoGetCurrentPage() {\n\treturn jQuery(location).attr("pathname").split("/").pop();\n}\n\nwindow.wpseoGetCurrentPage = wpseoGetCurrentPage;\n\n/**\n * Gets the name of the field to get the slug from, based on the current URL.\n *\n * For posts, this is \'post_name\', for terms it is \'slug\'.\n *\n * @param {string} currentPage The current page.\n *\n * @returns {string} The current slug field name.\n */\nfunction wpseoGetSlugField(currentPage) {\n\tcurrentPage = currentPage || wpseoGetCurrentPage();\n\n\tif (currentPage === "edit-tags.php") {\n\t\treturn "slug";\n\t}\n\n\treturn "post_name";\n}\n\n/**\n * Gets the currently active editor used in quick edit.\n *\n * @returns {Object} The editor that is currently active.\n */\nfunction wpseoGetActiveEditor() {\n\treturn jQuery("tr.inline-editor");\n}\n\nwindow.wpseoGetActiveEditor = wpseoGetActiveEditor;\n\n/**\n * Gets the current post or term id.\n * Returns an empty string if no editor is currently active.\n *\n * @returns {string} The ID of the current post or term.\n */\nfunction wpseoGetItemId() {\n\tvar editor = wpseoGetActiveEditor();\n\n\tif (editor.length === 0 || editor === "") {\n\t\treturn "";\n\t}\n\n\treturn editor.attr("id").replace("edit-", "");\n}\n\nwindow.wpseoGetItemId = wpseoGetItemId;\n\n/**\n * Gets the current slug of a post based on the current page and post or term being edited.\n *\n * @returns {string} The slug of the current post or term.\n */\nfunction wpseoGetCurrentSlug() {\n\tvar currentPost = wpseoGetItemId();\n\tvar slugField = wpseoGetSlugField();\n\n\treturn jQuery("#inline_" + currentPost).find("." + slugField).html();\n}\n\nwindow.wpseoGetCurrentSlug = wpseoGetCurrentSlug;\n\n/**\n * Checks whether or not the slug has changed.\n *\n * @returns {boolean} Whether or not the slug has changed.\n */\nfunction wpseoSlugChanged() {\n\tvar editor = wpseoGetActiveEditor();\n\tvar slugField = wpseoGetSlugField();\n\tvar currentSlug = wpseoGetCurrentSlug();\n\tvar newSlug = editor.find("input[name=" + slugField + "]").val();\n\n\treturn currentSlug !== newSlug;\n}\n\nwindow.wpseoSlugChanged = wpseoSlugChanged;\n\n/**\n * Handles the key-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleKeyEvents(ev) {\n\t// 13 refers to the enter key.\n\tif (ev.which === 13 && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleKeyEvents = wpseoHandleKeyEvents;\n\n/**\n * Handles the button-based events in the quick edit editor.\n *\n * @param {Event} ev The event currently being executed.\n *\n * @returns {void}\n */\nfunction wpseoHandleButtonEvents(ev) {\n\tif (jQuery(ev.target).attr("id") !== "save-order" && wpseoSlugChanged()) {\n\t\twpseoShowNotification();\n\t}\n}\n\nwindow.wpseoHandleButtonEvents = wpseoHandleButtonEvents;\n\nwindow.wpseoUndoRedirect = redirectFunctions.wpseoUndoRedirect;\nwindow.wpseoUndoRedirectByObjectId = redirectFunctions.wpseoUndoRedirectByObjectId;\nwindow.wpseoCreateRedirect = redirectFunctions.wpseoCreateRedirect;\nwindow.wpseoRemoveNotification = redirectFunctions.wpseoRemoveNotification;\n\njQuery(function () {\n\tvar wpseoCurrentPage = wpseoGetCurrentPage();\n\n\tif (["edit.php", "edit-tags.php"].includes(wpseoCurrentPage)) {\n\t\tjQuery("#inline-edit input").on("keydown", function (ev) {\n\t\t\twpseoHandleKeyEvents(ev);\n\t\t});\n\n\t\tjQuery(".button-primary").on("click", function (ev) {\n\t\t\twpseoHandleButtonEvents(ev);\n\t\t});\n\t}\n\n\tif (wpseoCurrentPage === "edit-tags.php") {\n\t\tjQuery(document).on("ajaxComplete", function (e, xhr, settings) {\n\t\t\tif (settings.data.indexOf("action=delete-tag") > -1) {\n\t\t\t\twpseoShowNotification();\n\t\t\t}\n\t\t});\n\t}\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTAwLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vL2Fzc2V0cy9qcy9zcmMvcXVpY2tlZGl0LW5vdGlmaWNhdGlvbi5qcz80Mzc3Il0sInNvdXJjZXNDb250ZW50IjpbIi8qIGdsb2JhbCBhamF4dXJsICovXG4vKiBqc2hpbnQgLVcwOTcgKi9cblxudmFyIHJlZGlyZWN0RnVuY3Rpb25zID0gcmVxdWlyZSggXCIuL3JlZGlyZWN0cy9mdW5jdGlvbnNcIiApO1xuXG4vKipcbiAqIFVzZSBub3RpZmljYXRpb24gY291bnRlciBzbyB3ZSBjYW4gY291bnQgaG93IG1hbnkgdGltZXMgdGhlIGZ1bmN0aW9uIHdwc2VvU2hvd05vdGlmaWNhdGlvbiBpcyBjYWxsZWQuXG4gKlxuICogQHR5cGUge251bWJlcn1cbiAqL1xudmFyIHdwc2VvTm90aWZpY2F0aW9uQ291bnRlciA9IDA7XG5cbi8qKlxuICogU2hvdyBub3RpZmljYXRpb24gdG8gdXNlciB3aGVuIHRoZXJlJ3MgYSByZWRpcmVjdCBjcmVhdGVkLiBXaGVuIHRoZSByZXNwb25zZSBpcyBlbXB0eSwgdXAgdGhlIG5vdGlmaWNhdGlvbiBjb3VudGVyXG4gKiB3aXRoIDEsIHdhaXQgMTAwIG1zIGFuZCBjYWxsIGZ1bmN0aW9uIGFnYWluLlxuICogU3RvcCB3aGVuIHRoZSBub3RpZmljYXRpb24gY291bnRlciBpcyBiaWdnZXIgdGhhbiAyMC5cbiAqXG4gKiBAcmV0dXJucyB7dm9pZH1cbiAqL1xuZnVuY3Rpb24gd3BzZW9TaG93Tm90aWZpY2F0aW9uKCkge1xuXHRqUXVlcnkucG9zdChcblx0XHRhamF4dXJsLFxuXHRcdHsgYWN0aW9uOiBcInlvYXN0X2dldF9ub3RpZmljYXRpb25zXCIgfSxcblx0XHRmdW5jdGlvbiggcmVzcG9uc2UgKSB7XG5cdFx0XHRpZiAoIHJlc3BvbnNlICE9PSBcIlwiICkge1xuXHRcdFx0XHR2YXIgaW5zZXJ0QWZ0ZXJFbGVtZW50ID0galF1ZXJ5KCBcIi53cmFwXCIgKS5jaGlsZHJlbigpLmVxKCAwICk7XG5cdFx0XHRcdGpRdWVyeSggcmVzcG9uc2UgKS5pbnNlcnRBZnRlciggaW5zZXJ0QWZ0ZXJFbGVtZW50ICk7XG5cdFx0XHRcdHdwc2VvTm90aWZpY2F0aW9uQ291bnRlciA9IDA7XG5cdFx0XHR9XG5cblx0XHRcdGlmICggd3BzZW9Ob3RpZmljYXRpb25Db3VudGVyIDwgMjAgJiYgcmVzcG9uc2UgPT09IFwiXCIgKSB7XG5cdFx0XHRcdHdwc2VvTm90aWZpY2F0aW9uQ291bnRlcisrO1xuXHRcdFx0XHRzZXRUaW1lb3V0KCB3cHNlb1Nob3dOb3RpZmljYXRpb24sIDUwMCApO1xuXHRcdFx0fVxuXHRcdH0sXG5cdCk7XG59XG5cbndpbmRvdy53cHNlb1Nob3dOb3RpZmljYXRpb24gPSB3cHNlb1Nob3dOb3RpZmljYXRpb247XG5cbi8qKlxuICogR2V0cyB0aGUgY3VycmVudCBwYWdlIGJhc2VkIG9uIHRoZSBjdXJyZW50IFVSTC5cbiAqXG4gKiBAcmV0dXJucyB7c3RyaW5nfSBUaGUgY3VycmVudCBwYWdlLlxuICovXG5mdW5jdGlvbiB3cHNlb0dldEN1cnJlbnRQYWdlKCkge1xuXHRyZXR1cm4galF1ZXJ5KCBsb2NhdGlvbiApLmF0dHIoIFwicGF0aG5hbWVcIiApLnNwbGl0KCBcIi9cIiApLnBvcCgpO1xufVxuXG53aW5kb3cud3BzZW9HZXRDdXJyZW50UGFnZSA9IHdwc2VvR2V0Q3VycmVudFBhZ2U7XG5cbi8qKlxuICogR2V0cyB0aGUgbmFtZSBvZiB0aGUgZmllbGQgdG8gZ2V0IHRoZSBzbHVnIGZyb20sIGJhc2VkIG9uIHRoZSBjdXJyZW50IFVSTC5cbiAqXG4gKiBGb3IgcG9zdHMsIHRoaXMgaXMgJ3Bvc3RfbmFtZScsIGZvciB0ZXJtcyBpdCBpcyAnc2x1ZycuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGN1cnJlbnRQYWdlIFRoZSBjdXJyZW50IHBhZ2UuXG4gKlxuICogQHJldHVybnMge3N0cmluZ30gVGhlIGN1cnJlbnQgc2x1ZyBmaWVsZCBuYW1lLlxuICovXG5mdW5jdGlvbiB3cHNlb0dldFNsdWdGaWVsZCggY3VycmVudFBhZ2UgKSB7XG5cdGN1cnJlbnRQYWdlID0gY3VycmVudFBhZ2UgfHwgd3BzZW9HZXRDdXJyZW50UGFnZSgpO1xuXG5cdGlmICggY3VycmVudFBhZ2UgPT09IFwiZWRpdC10YWdzLnBocFwiICkge1xuXHRcdHJldHVybiBcInNsdWdcIjtcblx0fVxuXG5cdHJldHVybiBcInBvc3RfbmFtZVwiO1xufVxuXG4vKipcbiAqIEdldHMgdGhlIGN1cnJlbnRseSBhY3RpdmUgZWRpdG9yIHVzZWQgaW4gcXVpY2sgZWRpdC5cbiAqXG4gKiBAcmV0dXJucyB7T2JqZWN0fSBUaGUgZWRpdG9yIHRoYXQgaXMgY3VycmVudGx5IGFjdGl2ZS5cbiAqL1xuZnVuY3Rpb24gd3BzZW9HZXRBY3RpdmVFZGl0b3IoKSB7XG5cdHJldHVybiBqUXVlcnkoIFwidHIuaW5saW5lLWVkaXRvclwiICk7XG59XG5cbndpbmRvdy53cHNlb0dldEFjdGl2ZUVkaXRvciA9IHdwc2VvR2V0QWN0aXZlRWRpdG9yO1xuXG4vKipcbiAqIEdldHMgdGhlIGN1cnJlbnQgcG9zdCBvciB0ZXJtIGlkLlxuICogUmV0dXJucyBhbiBlbXB0eSBzdHJpbmcgaWYgbm8gZWRpdG9yIGlzIGN1cnJlbnRseSBhY3RpdmUuXG4gKlxuICogQHJldHVybnMge3N0cmluZ30gVGhlIElEIG9mIHRoZSBjdXJyZW50IHBvc3Qgb3IgdGVybS5cbiAqL1xuZnVuY3Rpb24gd3BzZW9HZXRJdGVtSWQoKSB7XG5cdHZhciBlZGl0b3IgPSB3cHNlb0dldEFjdGl2ZUVkaXRvcigpO1xuXG5cdGlmICggZWRpdG9yLmxlbmd0aCA9PT0gMCB8fCBlZGl0b3IgPT09IFwiXCIgKSB7XG5cdFx0cmV0dXJuIFwiXCI7XG5cdH1cblxuXHRyZXR1cm4gZWRpdG9yLmF0dHIoIFwiaWRcIiApLnJlcGxhY2UoIFwiZWRpdC1cIiwgXCJcIiApO1xufVxuXG53aW5kb3cud3BzZW9HZXRJdGVtSWQgPSB3cHNlb0dldEl0ZW1JZDtcblxuLyoqXG4gKiBHZXRzIHRoZSBjdXJyZW50IHNsdWcgb2YgYSBwb3N0IGJhc2VkIG9uIHRoZSBjdXJyZW50IHBhZ2UgYW5kIHBvc3Qgb3IgdGVybSBiZWluZyBlZGl0ZWQuXG4gKlxuICogQHJldHVybnMge3N0cmluZ30gVGhlIHNsdWcgb2YgdGhlIGN1cnJlbnQgcG9zdCBvciB0ZXJtLlxuICovXG5mdW5jdGlvbiB3cHNlb0dldEN1cnJlbnRTbHVnKCkge1xuXHR2YXIgY3VycmVudFBvc3QgPSB3cHNlb0dldEl0ZW1JZCgpO1xuXHR2YXIgc2x1Z0ZpZWxkICAgPSB3cHNlb0dldFNsdWdGaWVsZCgpO1xuXG5cdHJldHVybiBqUXVlcnkoIFwiI2lubGluZV9cIiArIGN1cnJlbnRQb3N0ICkuZmluZCggXCIuXCIgKyBzbHVnRmllbGQgKS5odG1sKCk7XG59XG5cbndpbmRvdy53cHNlb0dldEN1cnJlbnRTbHVnID0gd3BzZW9HZXRDdXJyZW50U2x1ZztcblxuLyoqXG4gKiBDaGVja3Mgd2hldGhlciBvciBub3QgdGhlIHNsdWcgaGFzIGNoYW5nZWQuXG4gKlxuICogQHJldHVybnMge2Jvb2xlYW59IFdoZXRoZXIgb3Igbm90IHRoZSBzbHVnIGhhcyBjaGFuZ2VkLlxuICovXG5mdW5jdGlvbiB3cHNlb1NsdWdDaGFuZ2VkKCkge1xuXHR2YXIgZWRpdG9yICAgICAgPSB3cHNlb0dldEFjdGl2ZUVkaXRvcigpO1xuXHR2YXIgc2x1Z0ZpZWxkICAgPSB3cHNlb0dldFNsdWdGaWVsZCgpO1xuXHR2YXIgY3VycmVudFNsdWcgPSB3cHNlb0dldEN1cnJlbnRTbHVnKCk7XG5cdHZhciBuZXdTbHVnICAgICA9IGVkaXRvci5maW5kKCBcImlucHV0W25hbWU9XCIgKyBzbHVnRmllbGQgKyBcIl1cIiApLnZhbCgpO1xuXG5cdHJldHVybiBjdXJyZW50U2x1ZyAhPT0gbmV3U2x1Zztcbn1cblxud2luZG93Lndwc2VvU2x1Z0NoYW5nZWQgPSB3cHNlb1NsdWdDaGFuZ2VkO1xuXG4vKipcbiAqIEhhbmRsZXMgdGhlIGtleS1iYXNlZCBldmVudHMgaW4gdGhlIHF1aWNrIGVkaXQgZWRpdG9yLlxuICpcbiAqIEBwYXJhbSB7RXZlbnR9IGV2IFRoZSBldmVudCBjdXJyZW50bHkgYmVpbmcgZXhlY3V0ZWQuXG4gKlxuICogQHJldHVybnMge3ZvaWR9XG4gKi9cbmZ1bmN0aW9uIHdwc2VvSGFuZGxlS2V5RXZlbnRzKCBldiApIHtcblx0Ly8gMTMgcmVmZXJzIHRvIHRoZSBlbnRlciBrZXkuXG5cdGlmICggZXYud2hpY2ggPT09IDEzICYmIHdwc2VvU2x1Z0NoYW5nZWQoKSApIHtcblx0XHR3cHNlb1Nob3dOb3RpZmljYXRpb24oKTtcblx0fVxufVxuXG53aW5kb3cud3BzZW9IYW5kbGVLZXlFdmVudHMgPSB3cHNlb0hhbmRsZUtleUV2ZW50cztcblxuLyoqXG4gKiBIYW5kbGVzIHRoZSBidXR0b24tYmFzZWQgZXZlbnRzIGluIHRoZSBxdWljayBlZGl0IGVkaXRvci5cbiAqXG4gKiBAcGFyYW0ge0V2ZW50fSBldiBUaGUgZXZlbnQgY3VycmVudGx5IGJlaW5nIGV4ZWN1dGVkLlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfVxuICovXG5mdW5jdGlvbiB3cHNlb0hhbmRsZUJ1dHRvbkV2ZW50cyggZXYgKSB7XG5cdGlmICggalF1ZXJ5KCBldi50YXJnZXQgKS5hdHRyKCBcImlkXCIgKSAhPT0gXCJzYXZlLW9yZGVyXCIgJiYgd3BzZW9TbHVnQ2hhbmdlZCgpICkge1xuXHRcdHdwc2VvU2hvd05vdGlmaWNhdGlvbigpO1xuXHR9XG59XG5cbndpbmRvdy53cHNlb0hhbmRsZUJ1dHRvbkV2ZW50cyA9IHdwc2VvSGFuZGxlQnV0dG9uRXZlbnRzO1xuXG53aW5kb3cud3BzZW9VbmRvUmVkaXJlY3QgPSByZWRpcmVjdEZ1bmN0aW9ucy53cHNlb1VuZG9SZWRpcmVjdDtcbndpbmRvdy53cHNlb1VuZG9SZWRpcmVjdEJ5T2JqZWN0SWQgPSByZWRpcmVjdEZ1bmN0aW9ucy53cHNlb1VuZG9SZWRpcmVjdEJ5T2JqZWN0SWQ7XG53aW5kb3cud3BzZW9DcmVhdGVSZWRpcmVjdCA9IHJlZGlyZWN0RnVuY3Rpb25zLndwc2VvQ3JlYXRlUmVkaXJlY3Q7XG53aW5kb3cud3BzZW9SZW1vdmVOb3RpZmljYXRpb24gPSByZWRpcmVjdEZ1bmN0aW9ucy53cHNlb1JlbW92ZU5vdGlmaWNhdGlvbjtcblxuKCBqUXVlcnkoIGZ1bmN0aW9uKCkge1xuXHR2YXIgd3BzZW9DdXJyZW50UGFnZSA9IHdwc2VvR2V0Q3VycmVudFBhZ2UoKTtcblxuXHRpZiAoIFsgXCJlZGl0LnBocFwiLCBcImVkaXQtdGFncy5waHBcIiBdLmluY2x1ZGVzKCB3cHNlb0N1cnJlbnRQYWdlICkgKSB7XG5cdFx0alF1ZXJ5KCBcIiNpbmxpbmUtZWRpdCBpbnB1dFwiICkub24oIFwia2V5ZG93blwiLCBmdW5jdGlvbiggZXYgKSB7XG5cdFx0XHR3cHNlb0hhbmRsZUtleUV2ZW50cyggZXYgKTtcblx0XHR9ICk7XG5cblx0XHRqUXVlcnkoIFwiLmJ1dHRvbi1wcmltYXJ5XCIgKS5vbiggXCJjbGlja1wiLCBmdW5jdGlvbiggZXYgKSB7XG5cdFx0XHR3cHNlb0hhbmRsZUJ1dHRvbkV2ZW50cyggZXYgKTtcblx0XHR9ICk7XG5cdH1cblxuXHRpZiAoIHdwc2VvQ3VycmVudFBhZ2UgPT09IFwiZWRpdC10YWdzLnBocFwiICkge1xuXHRcdGpRdWVyeSggZG9jdW1lbnQgKS5vbiggXCJhamF4Q29tcGxldGVcIiwgZnVuY3Rpb24oIGUsIHhociwgc2V0dGluZ3MgKSB7XG5cdFx0XHRpZiAoIHNldHRpbmdzLmRhdGEuaW5kZXhPZiggXCJhY3Rpb249ZGVsZXRlLXRhZ1wiICkgPiAtMSApIHtcblx0XHRcdFx0d3BzZW9TaG93Tm90aWZpY2F0aW9uKCk7XG5cdFx0XHR9XG5cdFx0fSApO1xuXHR9XG59ICkgKTtcbiJdLCJtYXBwaW5ncyI6Ijs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBOzs7Ozs7O0FBT0E7QUFDQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7OztBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7QUFTQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7OztBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7QUFNQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7OztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///100\n')},18:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoUndoRedirectForObject = wpseoUndoRedirectForObject;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoUndoRedirectByObjectId = wpseoUndoRedirectByObjectId;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(9);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Deletes a redirect based on a post or term ID.\n *\n * @param {number} objectId   The post or term ID.\n * @param {number} objectType The object type: post or term.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirectForObject(objectId, objectType) {\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/undo-for-object",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\tobj_id: objectId,\n\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\tobj_type: objectType\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Undoes a redirect based on a post or term ID.\n *\n * @param {number} objectId   The post or term ID.\n * @param {number} objectType The object type: post or term.\n * @param {object} source     The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirectByObjectId(objectId, objectType, source) {\n\twpseoUndoRedirectForObject(objectId, objectType).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///18\n')},9:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy53cC5hcGlGZXRjaFwiP2JjMGYiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cud3AuYXBpRmV0Y2g7Il0sIm1hcHBpbmdzIjoiQUFBQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///9\n")}},[[100,0]]]);