(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[4],{99:function(module,exports,__webpack_require__){"use strict";eval('\n\n/* global YoastCustomFieldsPluginL10 */\n/* global YoastSEO */\n/* global _ */\n(function () {\n\t/**\n  * The Yoast Custom Fields Plugin adds the custom fields to the content that were defined in the titles and meta\'s\n  * section of the Yoast SEO settings when those fields are available.\n  *\n  * @constructor\n  * @property {Array} customFieldNames\n  * @property {Object} customFields\n  */\n\tvar YoastCustomFieldsPlugin = function YoastCustomFieldsPlugin() {\n\t\tYoastSEO.app.registerPlugin("YoastCustomFieldsPlugin", { status: "loading" });\n\n\t\tthis.customFields = {};\n\n\t\tthis.updateCustomFields();\n\t\tthis.declareReady();\n\t};\n\n\t/**\n  * Declares ready with YoastSEO.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.declareReady = function () {\n\t\tYoastSEO.app.pluginReady("YoastCustomFieldsPlugin");\n\t\tYoastSEO.app.registerModification("content", this.addCustomFields.bind(this), "YoastCustomFieldsPlugin");\n\t};\n\n\t/**\n  * Declares reloaded with YoastSEO.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.declareReloaded = function () {\n\t\tYoastSEO.app.pluginReloaded("YoastCustomFieldsPlugin");\n\t};\n\n\t/**\n  * The callback used to add the custom fields to the content to be analyzed by YoastSEO.js.\n  *\n  * @param {String} content The content for adding the custom fields to.\n  * @returns {String} The content.\n  */\n\tYoastCustomFieldsPlugin.prototype.addCustomFields = function (content) {\n\t\tfor (var fieldName in this.customFields) {\n\t\t\tcontent += " ";\n\t\t\tcontent += this.customFields[fieldName];\n\t\t}\n\t\treturn content;\n\t};\n\n\t/**\n  * Fetches the relevant custom fields from the form and saves them in a property.\n  * Then declares reloaded and rebinds the custom fields form.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.updateCustomFields = function () {\n\t\tvar customFields = {};\n\t\tjQuery("#the-list > tr:visible").each(function (i, el) {\n\t\t\tvar customFieldName = jQuery("#" + el.id + "-key").val();\n\t\t\tif (YoastCustomFieldsPluginL10.custom_field_names.indexOf(customFieldName) !== -1) {\n\t\t\t\tcustomFields[customFieldName] = jQuery("#" + el.id + "-value").val();\n\t\t\t}\n\t\t});\n\t\tthis.customFields = customFields;\n\t\tthis.declareReloaded();\n\t\tthis.bindCustomFields();\n\t};\n\n\t/**\n  * Adds the necessary event bindings for monitoring which custom fields are added/removed/updated.\n  *\n  * @returns {void}\n  */\n\tYoastCustomFieldsPlugin.prototype.bindCustomFields = function () {\n\t\tvar callback = _.debounce(this.updateCustomFields.bind(this), 500, true);\n\n\t\tjQuery("#the-list .button + .update_meta").off("click.wpseoCustomFields").on("click.wpseoCustomFields", callback);\n\t\tjQuery("#the-list").off("wpListDelEnd.wpseoCustomFields").on("wpListDelEnd.wpseoCustomFields", callback);\n\t\tjQuery("#the-list").off("wpListAddEnd.wpseoCustomFields").on("wpListAddEnd.wpseoCustomFields", callback);\n\t\tjQuery("#the-list textarea").off("input.wpseoCustomFields").on("input.wpseoCustomFields", callback);\n\t};\n\n\tif (typeof YoastSEO !== "undefined" && typeof YoastSEO.app !== "undefined") {\n\t\tnew YoastCustomFieldsPlugin();\n\t} else {\n\t\tjQuery(window).on("YoastSEO:ready", function () {\n\t\t\tnew YoastCustomFieldsPlugin();\n\t\t});\n\t}\n})();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///99\n')}},[[99,0]]]);